import hxvlc.flixel.FlxVideoSprite;
var vhs = new CustomShader('vcr'); 
var angel = new CustomShader('angel'); 
var Heat = new CustomShader('HeatWave'); 
var superCoolVId:FlxVideoSprite;

introLength = 0;
function onCountdown(event) event.cancel();

function create(){
    angel.data.pixel.value = [2, 2];
    angel.data.stronk.value = [2, 2];
    if (Options.gameplayShaders) camGame.addShader(angel);

	vhs.strengthMulti = .1;
    if (Options.gameplayShaders) camGame.addShader(vhs);

    camPiece = new FlxCamera();
	camPiece.bgColor = 0;
    FlxG.cameras.remove(camHUD, false);
    FlxG.cameras.add(camPiece, false);
	FlxG.cameras.add(camHUD, false);

    superCoolVId = new FlxVideoSprite();
    superCoolVId.load(Assets.getPath(Paths.video("Cutscene")));
    superCoolVId.cameras = [camPiece];
    superCoolVId.play();
    superCoolVId.pause();
    superCoolVId.alpha = 0.001;
    add(superCoolVId);

    grass1.alpha = bg1.alpha = grass2.alpha = bigstatic.alpha = bg2.alpha = boyfriend.alpha = camHUD.alpha = 0.001;
}

function onSubstateOpen(event) if (superCoolVId != null && paused && superCoolVId.alpha == 1) superCoolVId.pause();
function onSubstateClose(event) if (superCoolVId != null && paused && superCoolVId.alpha == 1) superCoolVId.resume();
function focusGained() if (superCoolVId != null && !paused && superCoolVId.alpha == 1) superCoolVId.resume();

function postCreate() {
    boyfriend.cameraOffset.set(-300,200);
    camera.fade(FlxColor.BLACK, .001);
    camera.zoom = camGame.zoom = defaultCamZoom = .8;

    for (i in [missesTxt, accuracyTxt, scoreTxt]) i.visible = false;
}
var lerpVal = .4;
function stepHit(curStep:Int) {
    switch (curStep) {
        case 120 | 136 | 153: camera.fade(FlxColor.BLACK, .5, false);
        case 212:
            camera.zoom = camGame.zoom = defaultCamZoom = .5;
            camera.fade(FlxColor.BLACK, 2, true);
            tweenZoom(.9, 4);   
        case 369:
            lerpVal = .2;
            tweenZoom(.7, 2);
            FlxTween.tween(boyfriend, {alpha: 1}, .4, {ease: FlxEase.quadInOut}); 
            FlxTween.tween(camHUD, {alpha: 1}, 1, {ease: FlxEase.quadInOut});

        case 400:  tweenZoom(.65, 8); 
        case 508:  grass1.alpha = bg1.alpha = 1;
        case 1248: camera.fade(FlxColor.WHITE, 2);
        case 1287: defaultCamZoom = camGame.zoom = camera.zoom = 1;
        case 1288: swithPhase2();
        case 2192: preCutscrean();
        case 2208: cutStart();
        case 2456: FlxTween.tween(camHUD, {alpha: 1}, 1, {ease: FlxEase.quadInOut});
        case 2736: defaultCamZoom = camGame.zoom = camera.zoom = 1; cutEnd();
        case 3024: songEnding();
    }
}
var evil:Bool = false;
function beatHit() {
    if(Options.gameplayShaders && evil && curBeat % 4 == 0 ){
        angelShader(.1, .2);
    }
}
function preCutscrean(){
    camera.flash(); 
    camera.fade(FlxColor.BLACK, 1);
    for (i in [healthBar, healthBarBG, iconP1, iconP2]) {
        FlxTween.tween(i, { alpha: 0 }, 1, { ease: FlxEase.circInOut }); 
    }

}
var crt = 0;
function update(elapsed){
    crt += elapsed;
    vhs.iTime = crt;

    Heat.iTime = crt;
    FlxG.camera.followLerp = lerpVal;
    if(angel != null){
        angel.data.stronk.value[0] = FlxMath.lerp(angel.data.stronk.value[0], 0, FlxMath.bound(elapsed * 8, 0, 1));

        angel.data.pixel.value[0] = FlxMath.lerp(angel.data.pixel.value[0], 1, FlxMath.bound(elapsed * 4, 0, 1));
        angel.data.iTime.value = [Conductor.songPosition / 1000];
    }
}
function angelShader(pixelVal,StrokeVal){
    angel.data.pixel.value = [pixelVal, pixelVal];
    angel.data.stronk.value = [StrokeVal, StrokeVal];
}
function swithPhase2(){
    evil = true;
    tweenZoom(.4, 8); 
    grass1.alpha = bg1.alpha = 0;
    camera.fade(FlxColor.WHITE, 2, true);
    FlxTween.tween(vhs, {strengthMulti: 1}, 4, {startDelay: 2, ease: FlxEase.quadInOut}); 
    FlxTween.tween(bg2, {alpha: 1}, 8, {startDelay: 7, ease: FlxEase.quadInOut});
    FlxTween.tween(grass2, {alpha: 1}, 3, {startDelay: 3,ease: FlxEase.quadInOut});
    FlxTween.tween(bigstatic, {alpha: 1}, 5, {startDelay: 5,ease: FlxEase.quadInOut});
    dad.cameraOffset.y = boyfriend.cameraOffset.y -= 400;

    for (i in 0...4) {
        var divisor = (i == 0) ? 2 : i;
        FlxTween.tween(cpuStrums.members[i], {
            y: cpuStrums.members[i].y + 4000 / divisor,
            angle: cpuStrums.members[i].angle + FlxG.random.float(-50, 1) / divisor
        }, 12, {ease: FlxEase.circInOut});
    }

}
function tweenZoom(value:Float, time:Float = 0.5) {
    FlxTween.tween(camGame, {zoom: value}, time, {ease: FlxEase.quadInOut});
    defaultCamZoom = value;
}
function cutStart(){
    superCoolVId.play();
    superCoolVId.alpha = 1;
    FlxTween.tween(camHUD, {alpha: 0}, 1, {ease: FlxEase.quadInOut});
}
function cutEnd() {
    evil = false;
    remove(superCoolVId);
    tweenZoom(1.2, 4);
    camera.fade(FlxColor.BLACK, 3, true);

    act3.alpha = 1;
    remove(boyfriend);
    insert(members.indexOf(dad), boyfriend);
    dad.x = 600;
    dad.cameraOffset.set(600, 0 );
    boyfriend.setPosition(700, 800);
    grass1.alpha = bg1.alpha = grass2.alpha = bigstatic.alpha = bg2.alpha = 0.001;

    if(Options.gameplayShaders) camGame.addShader(Heat);
}
function songEnding(){
    camera.fade(FlxColor.RED, .1);
    FlxTween.tween(camHUD, {alpha: 0}, 1, {ease: FlxEase.quadInOut});
}